%% Establishing the Topology Matrix for AM Filter
function [xi,varargout] = AMfilter3D(x, baseplate, TopMax, varargin)
%INTERNAL SETTINGS
P =40; ep = 1e-4; xi_0 = 0.5; % parameters for smooth max/min functions
%INPUT CHECKS
if nargin==1
    baseplate='S'; 
end
if baseplate=='X'
    % bypass option: filter does not modify the blueprint design
    xi = x;
    varargout = varargin;
    return;
end
nRot = find(upper(baseplate)=='SWNE')-1;

nSens=max(0,nargin-3);
if nargout~=nSens+1
    error('Input/output arguments mismatch.'); 
end
%ORIENTATION
%Top=[3, 2, 1];
%Right=[2,1,3];
%Left=[1,3,2];
x=permute(flip(x),[3, 2, 1]);
xi=zeros(size(x));
for s=1:nSens
     varargin{s}=permute(flip(varargin{s}),[3, 2, 1]);    
end

[nely,nelx,nelz]=size(x);

LayEleNum = zeros(nely+2,nelx+2);
LayEleNum(2:end-1,2:end-1) = reshape(1:(nelx)*(nely),nely,nelx);
TopMaxTmp = zeros(5,nely,nelx);
% Colume Order: 'W-N-M-S-E' 
TopMaxi = repmat(1:(nelx)*(nely),5,1);   TopMaxi = TopMaxi(:);
for xx = 2:nelx+1
    for yy = 2:nely+1
        TopMaxTmp(1,yy-1,xx-1) = LayEleNum(yy,xx-1);
        TopMaxTmp(2,yy-1,xx-1) = LayEleNum(yy-1,xx);
        TopMaxTmp(3,yy-1,xx-1) = LayEleNum(yy,xx);
        TopMaxTmp(4,yy-1,xx-1) = LayEleNum(yy+1,xx);
       TopMaxTmp(5,yy-1,xx-1) = LayEleNum(yy,xx+1);
    end
end
TopMaxj = TopMaxTmp(:);
TopMaxi(abs(TopMaxTmp(:)-0)<1e-9)=0;
TopMaxi(abs(TopMaxi-0)<1e-9)=[];
TopMaxj(abs(TopMaxTmp(:)-0)<1e-9)=[];
TopMax{1} = TopMaxi(:);     TopMax{2} = TopMaxj(:);   TopMax{3} = TopMaxTmp(:);

%AM FILTER =====================
Ns=5;
Q=P+log(Ns)/log(xi_0);
SHIFT = 100*realmin^(1/P); % small shift to prevent division by 0
BACKSHIFT = 0.95*Ns^(1/Q)*SHIFT^(P/Q);
Xi=zeros(size(x)); keep=zeros(size(x)); sq=zeros(size(x));
% baseline: identity
xi(:,:,1)=x(:,:,1); % copy base row as-is
for i = 2:1:nelz
    % compute maxima of current base row
    cbr = zeros(nely+2,nelx+2,1);
    cbr(2:end-1,2:end-1,1)= xi(:,:,i-1);
    cbr = cbr + SHIFT; % pad with zeros
    keep(:,:,i) = (cbr(2:(nely+1),1:nelx).^P + cbr(2:(nely+1),2:(nelx+1)).^P + cbr(2:(nely+1),3:end).^P + cbr(1:nely,2:(nelx+1)).^P + cbr(3:end,2:(nelx+1)).^P);
    Xi(:,:,i) = keep(:,:,i).^(1/Q) - BACKSHIFT;
    sq(:,:,i) = sqrt((x(:,:,i)-Xi(:,:,i)).^2 + ep);
    % set row above to supported value using smooth minimum:
    xi(:,:,i) = 0.5*((x(:,:,i)+Xi(:,:,i)) - sq(:,:,i) + sqrt(ep));
end
%SENSITIVITIES
if nSens
    dfxi=varargin; dfx=varargin;
    lambda=zeros(nSens,nely*nelx);
    % from top to base layer:
    for i = nelz:-1:2
        % smin sensitivity terms
        dsmindx  = .5*(1-(x(:,:,i)-Xi(:,:,i))./sq(:,:,i));
        dsmindXi = 1-dsmindx;
        % smax sensitivity terms
        cbr = zeros(nely+2,nelx+2,1);
        cbr(2:end-1,2:end-1,1)= xi(:,:,i-1);
        cbr = cbr + SHIFT; % pad with zeros
        dmx = zeros(Ns,nely,nelx);
        dmx(1,:,:) = (P/Q)*keep(:,:,i).^(1/Q-1).*cbr(2:end-1,1:nelx).^(P-1);    % W
        dmx(2,:,:) = (P/Q)*keep(:,:,i).^(1/Q-1).*cbr(1:nely,2:end-1).^(P-1);    % N
        dmx(3,:,:) = (P/Q)*keep(:,:,i).^(1/Q-1).*cbr(2:end-1,2:end-1).^(P-1);   % M
        dmx(4,:,:) = (P/Q)*keep(:,:,i).^(1/Q-1).*cbr(3:end,2:end-1).^(P-1);     % S
        dmx(5,:,:) = (P/Q)*keep(:,:,i).^(1/Q-1).*cbr(2:end-1,3:end).^(P-1);     % E
        % rearrange data for quick multiplication:
        qs=dmx(:); qs(find(abs(TopMax{3}-0)<1e-9))=[];
        dsmaxdxi=sparse(TopMax{1},TopMax{2},qs);
        for k=1:nSens
            dfxi_tmp = dfxi{k}(:,:,i);  dfxi_tmp=dfxi_tmp(:)';
            dfx_tmp = dsmindx(:)'.*(dfxi_tmp+lambda(k,:));
            dfx{k}(:,:,i) = reshape(dfx_tmp,nely,nelx);
            lambda(k,:)= ((dfxi_tmp+lambda(k,:)).*dsmindXi(:)')*dsmaxdxi;
        end
    end
    % base layer:
    i=1;
    for k=1:nSens
        dfx{k}(:,:,i) = dfxi{k}(:,:,i)+reshape(lambda(k,:),nely,nelx);
    end
end
%ORIENTATION
xi=flip(ipermute(xi,[3, 2, 1]));
for s=1:nSens
    varargout{s}=flip(ipermute(dfx{s}, [3, 2, 1]));  
end
end
